import { del, get, patch, post } from "@/lib/apiService";

const API_URL = "/api/assign-collections";

export const addAssignCollection = (data) => {
  return post(API_URL, data);
};

export const editAssignCollection = (data) => {
  return patch(API_URL, data);
};

export const deleteAssignCollection = (id) => {
  return del(API_URL, { id });
};

export const getAssignCollections = (
  pageIndex = 0,
  pageSize = 10,
  filters = {}
) => {
  const query = new URLSearchParams({
    pageIndex,
    pageSize,
    filters: JSON.stringify(filters),
  }).toString();

  return get(`${API_URL}?${query}`);
};
