import { del, get, patch, post } from "@/lib/apiService";
const API_URL = "/api/categories";

export const createCategory = (formData) => {
  return post(API_URL, formData);
};

export const editCategory = (formData) => {
  return patch(API_URL, formData);
};

export const deleteCategory = (id) => {
  return del(API_URL, { id });
};

export const getCategories = async (
  pageIndex = 0,
  pageSize = 10,
  tree = true,
  all = false,
  filters = {}
) => {
  const query = new URLSearchParams({
    pageIndex,
    pageSize,
    tree,
    all,
    filters: JSON.stringify(filters),
  }).toString();

  return get(`${API_URL}?${query}`);
};
export const getAllCategories = () => {
  const query = new URLSearchParams({
    all: true,
  }).toString();

  return get(`${process.env.NEXT_PUBLIC_BASE_URL}${API_URL}?${query}`);
};

export function getCategoryBySlug(slug) {
  return get(`${process.env.NEXT_PUBLIC_BASE_URL}${API_URL}/${slug}`);
}
