const API_URL = "/api/products";

import { del, get, patch, post } from "@/lib/apiService";

export const addProducts = (formData) => {
  return post(API_URL, formData);
};

export const editProducts = (formData) => {
  return patch(API_URL, formData);
};

export const deleteProducts = (id) => {
  return del(API_URL, { id });
};

export const getProducts = (pageIndex, pageSize, filters = {}) => {
  const query = new URLSearchParams({
    pageIndex: 0,
    pageSize: 10,
    filters: JSON.stringify(filters),
  }).toString();

  return get(`${API_URL}?${query}`);
};
export const getAllProducts = () => {
  const query = new URLSearchParams({
    all: true,
  }).toString();

  return get(`${process.env.NEXT_PUBLIC_BASE_URL}${API_URL}?${query}`);
};

export async function getProductBySlug(slug) {
  return get(`${process.env.NEXT_PUBLIC_BASE_URL}${API_URL}/${slug}`);
}
