import { del, get, patch, post } from "@/lib/apiService";

const API_URL = "/api/schemes";

export const addScheme = (formData) => {
  return post(API_URL, formData);
};

export const editScheme = (formData) => {
  return patch(API_URL, formData);
};

export const deleteScheme = (id) => {
  return del(API_URL, { id });
};

export const getSchemes = (pageIndex = 0, pageSize = 10, filters = {}) => {
  const query = new URLSearchParams({
    pageIndex,
    pageSize,
    filters: JSON.stringify(filters),
  }).toString();

  return get(`${API_URL}?${query}`);
};
