"use client";

import React from "react";

import { DataTable } from "@/components/ui/DataTableNew";

import AddAssignCollections from "./AddAssignCollections";

import {
  deleteAssignCollection,
  getAssignCollections,
} from "@/Services/AssignCollections/ApiAssignCollections";

const ProductCollections = () => {
  const columns = [
    {
      header: "Page",
      accessorKey: "page",
      enableHiding: false,
      cell: (info) =>
        info.getValue() == "/" ? "Home" : info.getValue().replace("/", ""),
    },
    {
      header: "Section Type",
      accessorKey: "section_type",
      enableHiding: false,
    },

    {
      header: "Collections",
      accessorKey: "collection_names",
    },
  ];

  return (
    <div>
      {/* <AddAssignCollections /> */}

      <DataTable
        title="Manage Assign Collections"
        fetchData={getAssignCollections}
        columnsConfig={columns}
        tag="assign_collections"
        onDelete={deleteAssignCollection}
        EditComponent={AddAssignCollections}
        showColumns={false}
      />
    </div>
  );
};

export default ProductCollections;
