"use client";

import { getMetals, deleteMetal } from "@/Services/Metals/ApiMetal";
import { useQuery } from "@tanstack/react-query";
import { Card, CardHeader, CardTitle, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Plus } from "lucide-react";
import { DataTable } from "@/components/ui/DataTableNew";
import { useModal } from "@/context/ModalProvider";
import AddMetalForm from "./AddMetal";

export default function MetalManagement() {
  const { openModal, closeModal } = useModal();

  const { data: metals = [] } = useQuery({
    queryKey: ["metals"],
    queryFn: getMetals,
  });

  const columns = [
    {
      accessorKey: "metal_name",
      header: "Metal Name",
      cell: (info) => info.getValue(),
    },
    {
      accessorKey: "unit",
      header: "Unit",
      cell: (info) => <span className="capitalize">{info.getValue()}</span>,
    },
    {
      accessorKey: "purity",
      header: "Purity/Carat",
      cell: (info) => info.getValue() || "-",
    },
    {
      accessorKey: "status",
      header: "Status",
      cell: (info) => (info.getValue() == 1 ? "Active" : "Inactive"),
    },
  ];

  return (
    <div>
      <AddMetalForm type="add" onClose={closeModal} />

      <DataTable
        title="Manage Metals"
        fetchData={getMetals}
        columnsConfig={columns}
        tag="metals"
        onDelete={deleteMetal}
        EditComponent={AddMetalForm}
      />
    </div>
  );
}
