"use client";

import React from "react";
import AddScheme from "./AddSchemes";
import { deleteScheme, getSchemes } from "@/Services/Schemes/ApiSchemes";
import { DataTable } from "@/components/ui/DataTableNew";
import { useModal } from "@/context/ModalProvider";
import { Button } from "@/components/ui/button";
import Image from "next/image";

const Schemes = () => {
  const { openModal } = useModal();
  const handleClick = (url) => {
    openModal(
      <div className="w-full h-full flex justify-center items-center">
        <Image
          src={url?.replace("/api", "")}
          alt="Testimonial"
          width={600}
          height={600}
          className="max-h-fit object-contain"
          loading="lazy"
        />
      </div>
    );
  };
  const columns = [
    {
      header: "Name",
      accessorKey: "name",
      enableHiding: false,
    },
    {
      header: "Alias",
      accessorKey: "alias",
    },
    {
      header: "Image",
      cell: (info) =>
        info.row.original.image ? (
          <Button
            variant="ghost"
            className="h-8 w-8 p-0"
            onClick={() => handleClick(info.row.original.image)}
          >
            <span className="sr-only">Open menu</span>
            <Image
              src={info.row.original.image?.replace("/api", "")}
              alt="testimonial"
              width={50}
              height={50}
              className="rounded"
              loading="lazy"
            />
          </Button>
        ) : (
          "No Image"
        ),
    },
  ];

  const searchFields = [
    {
      key: "name",
      type: "text",
      single: false,
    },
    {
      key: "alias",
      type: "text",
      single: false,
    },
  ];

  return (
    <div>
      <AddScheme />
      <DataTable
        title="Manage Schemes"
        fetchData={getSchemes}
        columnsConfig={columns}
        tag="schemes"
        searchFields="name"
        onDelete={deleteScheme}
        EditComponent={AddScheme}
      />
    </div>
  );
};

export default Schemes;
