import React from "react";
import Link from "next/link";

const AboutUs = () => {
  return (
    <div className="max-w-[1600px] mx-auto px-4 py-16 sm:px-6 lg:px-8">
      {/* Main Content with Image and Text */}
      <div className="grid grid-cols-1 md:grid-cols-2 gap-12 items-center mb-16 text-justify text-sm leading-relaxed">
        {/* Image Section */}
        <div className="rounded-lg overflow-hidden shadow-sm">
          <img
            src="/images/aboutus.jpg"
            alt="Skilled artisans crafting jewelry"
            className="w-full h-full object-cover"
          />
        </div>

        {/* Text Section */}
        <div className="space-y-6">
          <div>
            <h2 className="text-2xl font-semibold text-brand-dark mb-4">
              Our Heritage of Elegance
            </h2>
            <p className="text-gray-600 mb-3">
              Established in 1982, Selvakumar Jewellary has been a trusted name in
              traditional jewellery for over four decades. Rooted in the rich
              cultural heritage of Tamil Nadu, our brand was built on a deep
              passion for quality, craftsmanship, and timeless design.
            </p>
            <p className="text-gray-600 mb-3">
              From humble beginnings to becoming a household name, our journey
              has always been guided by one principle – to craft jewellery that
              carries tradition, emotion, and elegance.
            </p>
            <p className="text-gray-600">
              We specialize in high-standard, high-quality traditional
              jewellery, created using time-honored techniques by master
              artisans. Every piece we offer is more than just an ornament –
              it’s a work of art that reflects purity, authenticity, and grace.
            </p>
          </div>

          <div>
            <h2 className="text-2xl font-semibold text-brand-dark mb-4">
              Our Commitment
            </h2>
            <p className="text-gray-600">
              At Selvakumar Jewellary, our commitment to our customers goes beyond just
              selling jewellery – it's about building lifelong relationships
              based on trust, quality, and care. We believe every customer
              deserves not only exquisite designs but also true value for money.
              That's why each piece is thoughtfully priced without compromising
              on craftsmanship or purity.
            </p>
          </div>
        </div>
        {/* Values Section */}
        <div>
          <h2 className="text-2xl font-semibold text-brand-dark mb-4">
            The Selvakumar Jewellary Experience
          </h2>
          <p className="text-gray-600 mb-3 ">
            At Selvakumar Jewellary, visiting our store is more than just a shopping trip
            – it's a cultural experience rooted in tradition, trust, and
            timeless beauty. From the moment you enter, you're welcomed with
            warmth and personal attention.
          </p>
          <p className="text-gray-600 mb-3 ">
            From the moment you enter, you’re welcomed with warmth and personal
            attention. Our showroom is designed to offer a serene and
            comfortable environment where families can take their time, explore
            our exclusive collections, and find jewellery that truly speaks to
            them.
          </p>
          <p className="text-gray-600 mb-3 ">
            We take pride in offering lightweight, traditional jewellery that is
            both elegant and unique. Perfect for everyday wear or grand
            occasions, each piece is thoughtfully crafted to balance comfort
            with style – all while preserving the essence of Tamil Nadu’s rich
            jewellery heritage.
          </p>
        </div>

        <div className="rounded-lg overflow-hidden">
          <img
            src="/images/about-with-logo.png"
            alt="Skilled artisans crafting jewelry"
            className="w-full h-full object-cover"
          />
        </div>
      </div>

      {/* CTA Section */}
      <div className="bg-gradient-to-r from-brand-dark to-brand-gold rounded-lg shadow-xl overflow-hidden">
        <div className="grid grid-cols-1 md:grid-cols-2">
          <div className="p-10 flex items-center">
            <div>
              <h2 className="text-3xl font-bold text-white mb-4">
                Step Into a World of Tradition
              </h2>
              <p className="text-amber-100 mb-6">
                Our collections are curated for every milestone – from ear
                piercing ceremonies to puberty functions, engagements, haldi,
                weddings, and beyond. Each piece is made to suit the emotion of
                the occasion.
              </p>
              <Link href="/offers">
                <span className="inline-block bg-white text-brand-dark font-medium px-6 py-3 rounded-md shadow hover:bg-amber-50 transition duration-300 cursor-pointer">
                  View Collections
                </span>
              </Link>
            </div>
          </div>
          <div className="hidden md:block">
            <img
              src="/images/aboutus-cta.jpg"
              alt="Elegant jewelry collection"
              className="w-full h-full object-cover"
            />
          </div>
        </div>
      </div>
    </div>
  );
};

export default AboutUs;
