"use client";

import { useSettings } from "@/context/SettingsContext";
import { Facebook, Instagram, Twitter, X, Youtube } from "lucide-react";
import Link from "next/link";
import { FaXTwitter } from "react-icons/fa6";

const iconMap = {
  instagram: <Instagram className="w-5 h-5" />,
  facebook: <Facebook className="w-5 h-5" />,
  twitter: <FaXTwitter className="w-5 h-5" />,
  x: <X className="w-5 h-5" />,
  youtube: <Youtube className="w-5 h-5" />,
};

const ContactUs = () => {
  const { settings } = useSettings();
  return (
    <div className="max-w-[1600px] mx-auto px-4 py-16 sm:px-6 lg:px-8">
      {/* Contact Us Header */}
      {/* <div className="text-center mb-12">
        <h1 className="text-4xl font-bold text-brand-dark mb-4">Contact Us!</h1>
        <p className="text-lg text-gray-600 max-w-3xl mx-auto">
          The promise to "get back to you as soon as possible" assures prompt
          attention to inquiries.
        </p>
      </div> */}
      <div className="text-center mb-16">
        <div className="inline-block">
          <div className="flex items-center justify-center gap-4 mb-6">
            <div className="h-px w-16 bg-gradient-to-r from-transparent via-brand-gold to-brand-gold"></div>
            <div className="w-2 h-2 rotate-45 bg-brand-gold"></div>
            <div className="h-px w-16 bg-gradient-to-l from-transparent via-brand-gold to-brand-gold"></div>
          </div>
          <h1 className="font-cormorant text-4xl md:text-5xl font-bold text-primary mb-4 tracking-wide">
            Get In Touch
          </h1>
          <div className="flex items-center justify-center gap-4">
            <div className="h-px w-16 bg-gradient-to-r from-transparent via-brand-gold to-brand-gold"></div>
            <div className="w-2 h-2 rotate-45 bg-brand-gold"></div>
            <div className="h-px w-16 bg-gradient-to-l from-transparent via-brand-gold to-brand-gold"></div>
          </div>
        </div>
        <p className="text-gray-600 mt-6 max-w-2xl mx-auto font-lato text-lg">
          We're here to help you find the perfect piece. Reach out to our
          dedicated team.
        </p>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
        {/* <div className="bg-white p-8 rounded-lg shadow-lg flex flex-col justify-between h-[500px]"> */}
        <div className="bg-white/50 backdrop-blur-md p-8 rounded-lg shadow-lg flex flex-col justify-between h-[500px]">
          <div className="space-y-6">
            <div className="flex items-center">
              <div className="flex-shrink-0 text-brand-dark mr-4">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-6 w-6"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"
                  />
                </svg>
              </div>
              <Link href={`tel:${settings?.mobile}`} className="text-gray-700">
                {settings?.mobile}
              </Link>
            </div>

            {/* Email with Icon */}
            <div className="flex items-center">
              <div className="flex-shrink-0 text-brand-dark mr-4">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-6 w-6"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"
                  />
                </svg>
              </div>
              <Link
                href={`mailto:${settings?.email}`}
                className="text-gray-700 hover:text-brand-dark"
              >
                {settings?.email}
              </Link>
            </div>

            {/* Address with Icon */}
            <div className="flex items-center">
              <div className="flex-shrink-0 text-brand-dark mr-4">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-6 w-6"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"
                  />
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"
                  />
                </svg>
              </div>
              <span className="text-gray-700">{settings?.address}</span>
            </div>
            {/* Social Media Links at Bottom */}
            <div className="mt-8">
              <h3 className="text-lg font-medium text-brand-dark mb-4">
                Connect With Us
              </h3>
              <div className="flex gap-4 items-center">
                {settings?.social_links?.map((link, index) => {
                  const platform = link.platform?.toLowerCase();

                  const icon = iconMap[platform] || (
                    <span className="text-xs capitalize">{platform}</span>
                  );

                  return (
                    <Link
                      key={index}
                      href={link.url}
                      target="_blank"
                      rel="noopener noreferrer"
                      className="p-1 border border-brand-dark rounded-full text-brand-dark hover:bg-brand-gold transition"
                    >
                      {icon}
                    </Link>
                  );
                })}
              </div>
            </div>
          </div>
        </div>

        <div className="rounded-lg overflow-hidden shadow-lg h-[500px]">
          <iframe
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3929.4348827332246!2d78.140359355809!3d9.980889435671637!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3b00c7e7c80ce939%3A0x859e7d6a89b109a2!2sSELVAKUMAR%20JEWELLERY!5e0!3m2!1sen!2sin!4v1770212982068!5m2!1sen!2sin"
            width="100%"
            height="100%"
            style={{ border: 0 }}
            allowFullScreen=""
            loading="lazy"
            referrerPolicy="no-referrer-when-downgrade"
          ></iframe>
        </div>
      </div>
    </div>
  );
};

export default ContactUs;
