"use client";

import { useProductCollections } from "@/hooks/useData";
import { Loader2, ArrowRight } from "lucide-react";
import Image from "next/image";
import Link from "next/link";

const Offers = () => {
  const { data, isLoading } = useProductCollections();

  if (isLoading) {
    return (
      <div className="flex items-center justify-center h-64 w-full bg-stone-50">
        <Loader2 className="h-8 w-8 animate-spin text-brand-gold" />
      </div>
    );
  }

  // Filter active items
  const activeItems = data?.rows?.filter((item) => item.status === 1) || [];

  if (activeItems.length === 0) return null;

  return (
    <section className="py-20 px-4 md:px-8 bg-white">
      <div className="max-w-[1600px] mx-auto">
        {/* Optional Section Header */}
        <div className="text-center mb-12">
          <span className="text-xs font-lato uppercase tracking-[0.2em] text-brand-gold">
            Exclusive Selections
          </span>
          <h2 className="text-4xl md:text-5xl font-cormorant text-primary mt-2">
            Curated Collections
          </h2>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {activeItems.map((item) => {
            return (
              <div
                key={item.id}
                className="group relative overflow-hidden bg-stone-100"
              >
                <Link
                  href={`/${item.url}`}
                  className="block relative w-full h-full"
                >
                  {/* Card Aspect Ratio - Cinematic Landscape */}
                  <div className="relative w-full aspect-[16/10] overflow-hidden">
                    {/* 1. Image with Slow Zoom */}
                    <Image
                      src={item.image?.replace("/api", "")}
                      alt={item.name}
                      fill
                      className="object-cover transition-transform duration-[1.2s] ease-out group-hover:scale-110"
                      sizes="(max-width: 768px) 100vw, (max-width:1200px) 50vw, 33vw"
                    />

                    {/* 2. Gradient Overlay (Darkens on hover) */}
                    <div className="absolute inset-0 bg-gradient-to-t from-black/80 via-black/20 to-black/10 opacity-60 group-hover:opacity-80 transition-opacity duration-500" />

                    {/* 3. Luxury Inner Border Frame */}
                    <div className="absolute inset-4 border border-white/20 opacity-0 scale-95 group-hover:opacity-100 group-hover:scale-100 transition-all duration-500 ease-out z-10" />

                    {/* 4. Content */}
                    <div className="absolute inset-0 flex flex-col items-center justify-center p-6 text-center z-20">
                      {/* Title - Slides up slightly */}
                      <h3 className="text-2xl md:text-3xl lg:text-4xl font-cormorant font-medium text-white tracking-wide drop-shadow-sm transform transition-transform duration-500 group-hover:-translate-y-2 capitalize">
                        {item.name.toLowerCase()}
                      </h3>

                      {/* Divider Line - Expands */}
                      <div className="w-0 group-hover:w-12 h-[1px] bg-brand-gold my-3 transition-all duration-500 delay-75" />

                      {/* Button - Fades In */}
                      <div className="flex items-center gap-2 opacity-0 transform translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-500 delay-150">
                        <span className="text-xs font-lato text-white/90 uppercase tracking-[0.2em]">
                          Discover
                        </span>
                        <ArrowRight className="w-3 h-3 text-brand-gold" />
                      </div>
                    </div>
                  </div>
                </Link>
              </div>
            );
          })}
        </div>
      </div>
    </section>
  );
};

export default Offers;
