import SchemesCard from "@/components/Home/SchemesCard";

export default function Schemes() {
  return (
    <section className="w-full bg-white min-h-screen">
      <div className="max-w-[1600px] mx-auto px-6 py-16 md:py-24">
        {/* Editorial Header */}
        <div className="flex flex-col items-center text-center mb-20 space-y-5">
          <span className="uppercase tracking-[0.25em] text-xs font-bold text-brand-gold font-lato">
            Secure Your Future
          </span>

          <h1 className="text-4xl md:text-5xl font-medium text-primary font-cormorant">
            Gold Saving Schemes
          </h1>

          {/* Brand Gold Divider */}
          <div className="w-20 h-[2px] bg-brand-gold my-6 opacity-60"></div>

          <p className="text-base md:text-lg text-primary/80 max-w-3xl leading-relaxed font-lato font-light">
            At Selvakumar Jewellary, our Gold Saving Scheme helps you plan your jewelry
            purchase with ease. Customers can invest a fixed amount every month
            for 11 months and receive exclusive benefits upon maturity. The
            scheme ensures disciplined savings, flexibility, and attractive
            offers.
            <br className="hidden md:block" />
            With perks like{" "}
            <span className="text-brand-gold font-medium">
              free evaluation
            </span>{" "}
            and{" "}
            <span className="text-brand-gold font-medium">custom designs</span>,
            it’s our way of turning your savings into timeless treasures.
          </p>
        </div>

        {/* Card Section */}
        <SchemesCard />
      </div>
    </section>
  );
}
