import { AppSidebar } from "@/components/Back-End/Sidebar/AppSidebar";
import { SidebarProvider, SidebarTrigger } from "@/components/ui/sidebar";
import Providers from "@/context/provider";
import { getSettings } from "@/lib/getSettings";
export const generateMetadata = async () => {
  const [rows] = await getSettings();
  const settings = rows.reduce((acc, curr) => {
    acc[curr.settings_name] = curr.settings_value;
    return acc;
  }, {});

  return {
    title: settings?.name || "Selvakumar Jewellary",

    icons: {
      icon: [
        {
          url: settings?.icon?.replace("/api", "") || "/images/logo-dark.png",
          type: settings?.icon?.endsWith(".webp") ? "image/webp" : "image/png",
        },
      ],
    },
  };
};

export default function Layout({ children }) {
  return (
    <Providers>
      <SidebarProvider className="relative">
        <AppSidebar />
        <div className="flex flex-col w-full h-auto">
          <div className="sticky top-0 p-3 shadow z-40 bg-white">
            <SidebarTrigger />
          </div>
          <main className="z-0 overflow-y-auto p-3">{children}</main>
        </div>
      </SidebarProvider>
    </Providers>
  );
}
