"use client";

import {
  Home,
  Settings,
  LogOut,
  Network,
  Box,
  Boxes,
  GalleryHorizontal,
  GalleryHorizontalEnd,
  NotepadText,
  RectangleHorizontal,
  ChevronsLeftRight,
  Building2,
} from "lucide-react";
import { useState } from "react";
import Image from "next/image";
import { signOut } from "next-auth/react";
import {
  Sidebar,
  SidebarContent,
  SidebarGroup,
  SidebarGroupContent,
  SidebarGroupLabel,
  SidebarHeader,
  SidebarMenu,
  SidebarMenuButton,
  SidebarMenuItem,
} from "@/components/ui/sidebar";
import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from "@/components/ui/alert-dialog";
import { Button } from "@/components/ui/button";
import Link from "next/link";

// Menu items.
const items = [
  {
    title: "Home",
    url: "/dashboard",
    icon: Home,
  },
  {
    title: "Metals",
    url: "/dashboard/metal",
    icon: GalleryHorizontal,
  },
  {
    title: "Banners",
    url: "/dashboard/banner",
    icon: GalleryHorizontal,
  },
  {
    title: "cta",
    url: "/dashboard/cta",
    icon: RectangleHorizontal,
  },
  {
    title: "Testimonial",
    url: "/dashboard/testimonial",
    icon: GalleryHorizontalEnd,
  },
  {
    title: "Schemes",
    url: "/dashboard/schemes",
    icon: NotepadText,
  },
  {
    title: "Categories",
    url: "/dashboard/categories",
    icon: Network,
  },
  {
    title: "Products",
    url: "/dashboard/products",
    icon: Box,
  },
  {
    title: "Collections",
    url: "/dashboard/product-collections",
    icon: Boxes,
  },
  {
    title: "Assign Collections",
    url: "/dashboard/assign-collections",
    icon: Boxes,
  },
  {
    title: "Meta Management",
    url: "/dashboard/meta",
    icon: ChevronsLeftRight,
  },
  {
    title: "Branches",
    url: "/dashboard/branches",
    icon: Building2,
  },
  {
    title: "Settings",
    url: "/dashboard/settings",
    icon: Settings,
  },
];

export function AppSidebar() {
  return (
    <Sidebar className="flex flex-col justify-between bg-brand-dark">
      {/* ✅ Logo at the top */}
      <SidebarHeader className="p-2 flex justify-center bg-brand-dark">
        <div className="relative w-full h-[60px]">
          <Image
            src="/images/logo-light.png"
            alt="Selvakumar Jewellary Logo"
            fill
            priority
            sizes="(max-width: 768px) 200px, 180px"
            className="object-contain"
          />
        </div>
      </SidebarHeader>

      <SidebarContent className="flex-1 bg-brand-dark text-brand-gold">
        <SidebarGroup>
          <SidebarGroupContent>
            <SidebarMenu>
              {items.map((item) => (
                <SidebarMenuItem key={item.title}>
                  <SidebarMenuButton asChild>
                    <Link
                      href={item.url}
                      className="flex items-center gap-2 font-bold my-1"
                    >
                      <item.icon className="w-4 h-4" />
                      <span>{item.title}</span>
                    </Link>
                  </SidebarMenuButton>
                </SidebarMenuItem>
              ))}
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>
      </SidebarContent>

      {/* ✅ Logout with confirm modal */}
      <div className="p-4 border-t bg-brand-dark">
        <AlertDialog>
          <AlertDialogTrigger asChild>
            <Button
              variant="gold"
              className="w-full flex items-center justify-start gap-2"
            >
              <LogOut className="w-4 h-4" />
              Logout
            </Button>
          </AlertDialogTrigger>
          <AlertDialogContent>
            <AlertDialogHeader>
              <AlertDialogTitle>
                Are you sure you want to logout?
              </AlertDialogTitle>
            </AlertDialogHeader>
            <AlertDialogFooter>
              <AlertDialogCancel>Cancel</AlertDialogCancel>
              <AlertDialogAction
                className="bg-brand-dark"
                onClick={() => signOut({ callbackUrl: "/login" })}
              >
                Logout
              </AlertDialogAction>
            </AlertDialogFooter>
          </AlertDialogContent>
        </AlertDialog>
      </div>
    </Sidebar>
  );
}
