"use client";
import { useSchemes } from "@/hooks/useData";
import { Download, Eye, Loader2 } from "lucide-react";
import Image from "next/image";
import Link from "next/link";
import React from "react";

const SchemesCard = () => {
  const { data: schemes, isLoading } = useSchemes();

  if (isLoading) {
    return (
      <div className="flex items-center justify-center h-64 w-full">
        <Loader2 className="h-10 w-10 animate-spin text-brand-gold" />
      </div>
    );
  }

  return (
    <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8 md:gap-12">
      {schemes.rows.map((scheme) => {
        const img = scheme.image?.replace("/api", "");
        return (
          <div key={scheme.id} className="group flex flex-col cursor-pointer">
            {/* Image Container - Luxury Portrait Ratio */}
            <div className="relative w-full aspect-[1/1] overflow-hidden bg-gray-50 border border-brand-dark/10">
              <Image
                src={img}
                alt={scheme.name}
                fill
                sizes="(max-width: 768px) 100vw, (max-width: 1200px) 50vw, 33vw"
                className="object-cover transition-transform duration-1000 ease-out group-hover:scale-110"
              />

              {/* Elegant Overlay: Brand Dark with Fade */}
              <div
                className="absolute inset-0 bg-brand-dark/60 backdrop-blur-[1px] opacity-0 
                group-hover:opacity-100 transition-opacity duration-500 flex items-center justify-center gap-6"
              >
                <Link
                  href={scheme.image?.replace("/api", "")}
                  target="_blank"
                  className="bg-white text-brand-dark p-3 rounded-full hover:bg-brand-gold hover:text-white transition-all duration-300 transform translate-y-4 group-hover:translate-y-0"
                >
                  <Eye className="w-5 h-5" />
                </Link>
                <a
                  href={scheme.image?.replace("/api", "")}
                  download
                  className="bg-white text-brand-dark p-3 rounded-full hover:bg-brand-gold hover:text-white transition-all duration-300 transform translate-y-4 group-hover:translate-y-0 delay-75"
                >
                  <Download className="w-5 h-5" />
                </a>
              </div>
            </div>

            {/* Typography Content */}
            <div className="pt-6 text-center space-y-2">
              <Link
                href={scheme.image?.replace("/api", "")}
                title={scheme.name}
                target="_blank"
                className="text-2xl font-cormorant font-semibold text-brand-dark group-hover:text-brand-gold transition-colors duration-300 line-clamp-1"
              >
                {scheme.name}
              </Link>

              <div className="flex items-center justify-center gap-3">
                <span className="h-[1px] w-8 bg-brand-gold/40"></span>
                <p className="text-xs font-lato uppercase tracking-[0.2em] text-brand-dark/70 line-clamp-1">
                  {scheme.alias}
                </p>
                <span className="h-[1px] w-8 bg-brand-gold/40"></span>
              </div>
            </div>
          </div>
        );
      })}
    </div>
  );
};

export default SchemesCard;
