"use client";

import Image from "next/image";
import Link from "next/link";
import { ArrowRight } from "lucide-react"; // Assuming you have lucide-react, or remove icon

export default function ThreeBoxSection({ data }) {
  if (!data || data.length === 0) return null;

  return (
    <section className="py-16 px-4 md:px-8 bg-white">
      <div className="max-w-[1600px] mx-auto grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
        {data.map((item, i) => {
          const img = item.image?.replace("/api", "");

          return (
            <Link
              key={item.id}
              href={`/${item.url}`}
              className="group relative block overflow-hidden"
            >
              {/* Card Container - Aspect Ratio 3:4 for an Editorial/Portrait look */}
              <div className="relative w-full aspect-[1/1] overflow-hidden bg-stone-100">
                {/* 1. The Image - Slow Zoom Effect */}
                <Image
                  src={img}
                  alt={item.name}
                  fill
                  className="object-cover transition-transform duration-1000 ease-out group-hover:scale-110"
                  sizes="(max-width: 768px) 100vw, (max-width: 1200px) 50vw, 33vw"
                />

                {/* 2. Gradient Overlay - Improves text readability without harsh glass borders */}
                <div className="absolute inset-0 bg-gradient-to-t from-black/70 via-black/20 to-transparent opacity-60 group-hover:opacity-80 transition-opacity duration-500" />

                {/* 3. The "Gold Frame" - Appears on Hover */}
                <div className="absolute inset-4 border border-brand-gold/0 group-hover:border-brand-gold/70 transition-colors duration-700 z-10" />

                {/* 4. Content Content - Floating at bottom */}
                <div className="absolute inset-0 flex flex-col justify-end p-8 md:p-10 z-20">
                  <div className="transform transition-transform duration-500 translate-y-4 group-hover:translate-y-0">
                    {/* Decorative Line */}
                    <div className="w-12 h-[1px] bg-brand-gold mb-4 opacity-0 group-hover:opacity-100 transition-opacity duration-500 delay-100" />

                    <h3 className="text-3xl font-cormorant text-white font-medium italic tracking-wide">
                      {item.name}
                    </h3>

                    {/* Call to Action - Fades in */}
                    <div className="flex items-center gap-2 mt-2 opacity-0 group-hover:opacity-100 transition-opacity duration-500 delay-200">
                      <span className="text-xs text-stone-200 uppercase tracking-[0.2em] font-lato">
                        Explore Collection
                      </span>
                      <ArrowRight className="w-4 h-4 text-brand-gold" />
                    </div>
                  </div>
                </div>
              </div>
            </Link>
          );
        })}
      </div>
    </section>
  );
}
