"use client";
import { useSettings } from "@/context/SettingsContext";

export default function AppInitializer({ children }) {
  const { settings, loading } = useSettings();

  if (loading || !settings) {
    return (
      <div className="flex items-center justify-center min-h-screen bg-white">
        <div className="w-10 h-10 border-4 border-primary border-t-transparent rounded-full animate-spin"></div>
      </div>
    );
  }

  return children;
}
