import { useQuery } from "@tanstack/react-query";

// API imports
import { getCategories } from "@/Services/Categories/ApiCategory";
import { getProducts } from "@/Services/Products/ApiProducts";
import { getProductCollections } from "@/Services/ProductCollections/ApiProductCollections";
import { getAssignCollections } from "@/Services/AssignCollections/ApiAssignCollections";
import { getTestimonials } from "@/Services/Testimonial/ApiTestimonial";
import { getBanners } from "@/Services/Banner/ApiBanner";
import { getCtas } from "@/Services/Cta/ApiCta";
import { getSchemes } from "@/Services/Schemes/ApiSchemes";
import { getBranches } from "@/Services/Branches/ApiBranches";

// Default query options
const defaultQueryOptions = {
  staleTime: 1000 * 60 * 2, // 2 minutes
  gcTime: 1000 * 60 * 10, // 10 minutes
};

// Utility hook generator
const createQueryHook = (key, queryFn) => {
  return () =>
    useQuery({
      queryKey: [key],
      queryFn,
      ...defaultQueryOptions,
    });
};

// Hooks
export const useCategories = () =>
  useQuery({
    queryKey: ["categories"],
    queryFn: () => getCategories(0, 10, true, true),
    ...defaultQueryOptions,
  });

export const useCategoriesAll = () =>
  useQuery({
    queryKey: ["categories_all"],
    queryFn: () => getCategories(0, 10, false, true, true),
    ...defaultQueryOptions,
  });

export const useProducts = createQueryHook("products", getProducts);
export const useProductCollections = createQueryHook(
  "product_collections",
  getProductCollections
);
export const useAssignCollections = createQueryHook(
  "assign_collections",
  getAssignCollections
);
export const useTestimonials = createQueryHook("testimonials", getTestimonials);
export const useBanners = createQueryHook("banners", getBanners);
export const useCtas = createQueryHook("cta", getCtas);
export const useSchemes = createQueryHook("schemes", getSchemes);
export const useBranches = createQueryHook("branches", () => getBranches(true));

